# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_PORTUGUESE} "(Usar CD)"
LangString ReadOnly ${LANG_PORTUGUESE} "(Read Only)"
LangString MainHeaderSubText ${LANG_PORTUGUESE} "Por favor selecione o nome de utilizador e a palavra passe para a nova conta"
LangString MainLanguageLabel ${LANG_PORTUGUESE} "Idioma:"
LangString MainUsernameLabel ${LANG_PORTUGUESE} "Nome de utilizador:"
LangString MainPasswordLabel ${LANG_PORTUGUESE} "Senha:"
LangString MainInstallationSizeLabel ${LANG_PORTUGUESE} "Tamanho da Instalao (GB):"
LangString MainDistroLabel ${LANG_PORTUGUESE} "Ambiente de Trabalho:"
LangString MainInstallationDriveLabel ${LANG_PORTUGUESE} "Unidade de instalao:"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_PORTUGUESE} "Unidade de instalao:"
LangString MainUsernameToolTip ${LANG_PORTUGUESE} "Este vai ser o seu nome de utilizador do Ubuntu. $\r$\n Tem que conter apenas letras minsculas. $\r$\n No pode conter espaos."
LangString MainPasswordToolTip ${LANG_PORTUGUESE} "Este vai ser o seu nome de utilizador do Ubuntu. $\r$\n Tem que conter apenas letras minsculas. $\r$\n No pode conter espaos."
LangString MainInstallationSizeToolTip ${LANG_PORTUGUESE} "Quantos GB deseja reservar para o Ubuntu?$\r$\n4GB  o mnimo$\r$\n8GB  o recomendado"
LangString MainInstallationDriveToolTip ${LANG_PORTUGUESE} "Aqui vai ser instalado o Ubuntu num directrio chamado wubi.$\r$\nO dispositivo deve ter idealmente 10GB livres."
LangString Distro1ToolTip ${LANG_PORTUGUESE} "Por omiso  Ubuntu."
LangString Distro2ToolTip ${LANG_PORTUGUESE} "Kubuntu usa o ambiente KDE3.5"
LangString Distro3ToolTip ${LANG_PORTUGUESE} "Kubuntu-KDE4 usa o ambiente KDE4."
LangString Distro4ToolTip ${LANG_PORTUGUESE} "Xubuntu  bom para sistemas mais antigos."
LangString MainDistroToolTip ${LANG_PORTUGUESE} "Qual o ambiente grfico que deseja instalar?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_PORTUGUESE} "Por favor introduza um nome de utilizador vlido"
LangString ErrorSpaceInUsername ${LANG_PORTUGUESE} "Por favor no utilize espaos no nome de utilizador."
LangString ErrorUsernameUpperCase ${LANG_PORTUGUESE} "Por favor utilize letras minsculas."
LangString ErrorUsernameFirstCharNotLetter ${LANG_PORTUGUESE} "O nome de utilizador tem que comear com uma letra."
LangString ErrorUsernameIllegalChars ${LANG_PORTUGUESE} "O nome de utilizador apenas pode conter letras comuns e nmeros."
LangString ErrorReservedUsername ${LANG_PORTUGUESE} "O nome de utilizador escolhido est reservado, por favor seleccione um diferente."
LangString ErrorNoPassword ${LANG_PORTUGUESE} "Por favor introduza uma palavra passe vlida."
LangString ErrorPasswordMismatch ${LANG_PORTUGUESE} "A palavra passe no coincide."
LangString ErrorSpaceInPassword ${LANG_PORTUGUESE} "Por favor no utilize espaos na palavra passe."
LangString ErrorNoFreeSpace ${LANG_PORTUGUESE} "Espao insuficiente para reinstalar"
LangString ErrorNoKernel ${LANG_PORTUGUESE} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_PORTUGUESE} "Erro ao tentar executar :"
LangString ErrorWubibcd ${LANG_PORTUGUESE} "Erro ao tentar executar :"
LangString ErrorCD2ISO ${LANG_PORTUGUESE} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_PORTUGUESE} "A transferncia foi interrompida com o erro:"
LangString ErrorNoCD ${LANG_PORTUGUESE} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_PORTUGUESE} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_PORTUGUESE} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_PORTUGUESE} "Est prestes a instalar"
LangString InstallHeaderInitializing ${LANG_PORTUGUESE} "A instalar $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_PORTUGUESE} "Aguarde enquanto os ficheiros necessrios so preparados"
LangString InstallHeaderUncompressWubifolder ${LANG_PORTUGUESE} "A descompactar pasta do wubi..."
LangString InstallHeaderCopyIso ${LANG_PORTUGUESE} "A gravar cpia de segurana dos ficheiros de instalao..."
LangString InstallHeaderDownload ${LANG_PORTUGUESE} "A transferir ficheiros de instalao,  possvel recomear mais tarde"
LangString InstallHeaderBackupIso ${LANG_PORTUGUESE} "A gravar cpia de segurana dos ficheiros de instalao..."
LangString InstallHeaderWritePreseed ${LANG_PORTUGUESE} "A escrever ficheiros de configurao..."
LangString InstallHeaderWriteUninstaller ${LANG_PORTUGUESE} "A configurar o desinstalador..."
LangString InstallHeaderWriteBootLoader ${LANG_PORTUGUESE} "A configurar carregador do arranque..."
LangString InstallGenerateVirtualDisks ${LANG_PORTUGUESE} "A criar discos virtuais..."
LangString InstallCopyFiles ${LANG_PORTUGUESE} "A gravar cpia de segurana dos ficheiros de instalao..."
LangString InstallCreateFolders ${LANG_PORTUGUESE} "A criar discos virtuais..."
LangString InstallRetrieveIso ${LANG_PORTUGUESE} "A transferir ficheiros de instalao,  possvel recomear mais tarde"

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_PORTUGUESE} "j est instalado"
LangString UninstallAsk ${LANG_PORTUGUESE} "Est prestes a instalar"
LangString UninstallMessageField ${LANG_PORTUGUESE} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_PORTUGUESE} "Gravar cpia de segurana dos ficheiros transferidos"
LangString UninstallBackupHomeCheckBox ${LANG_PORTUGUESE} "Cpia de segurana dos documentos do Ubuntu (home.disk)"
LangString UninstallBackupLocationField ${LANG_PORTUGUESE} "Localizao da cpia de segurana:"

# FINISH
LangString EjectRebootMsg ${LANG_PORTUGUESE} " necessrio reiniciar para completar a instalao."
LangString RebootMsg ${LANG_PORTUGUESE} " necessrio reiniciar para completar a instalao."

# DOWNLOADER
LangString MetadlDownloading ${LANG_PORTUGUESE} "A copiar ficheiros de instalao..."
LangString MetadlChecking ${LANG_PORTUGUESE} "A gravar cpia de segurana dos ficheiros de instalao..."
LangString MetadlConnecting ${LANG_PORTUGUESE} "A ligar a %s..."
LangString MetadlInitializing ${LANG_PORTUGUESE} "A iniciar transferncia..."
LangString MetadlChecksums ${LANG_PORTUGUESE} "A calcular checksums..."
LangString MetadlRetrying1 ${LANG_PORTUGUESE} "A tentar em %d segundos... (%d de %d)"
LangString MetadlRetrying2 ${LANG_PORTUGUESE} "A tentar em %d segundos..."
LangString MetadlSecond ${LANG_PORTUGUESE} "segundo"
LangString MetadlSeconds ${LANG_PORTUGUESE} "segundos"
LangString MetadlProgress ${LANG_PORTUGUESE} "%s (%d%%) de %s @ %s/s"
LangString MetadlRemaining ${LANG_PORTUGUESE} " (%s restante)"
LangString PleaseConnect ${LANG_PORTUGUESE} "Por favor conecte-se  internet agora."

# ACCESSIBILITY
LangString MobilityAids ${LANG_PORTUGUESE} "Mobility Aids"
LangString VisibilityAids ${LANG_PORTUGUESE} "Visibility Aids"
LangString AccessibilityButton ${LANG_PORTUGUESE} "&Acessibilidade"
LangString AccessibilityText ${LANG_PORTUGUESE} "Accessibility profile"
LangString AccessibilitySubText ${LANG_PORTUGUESE} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_PORTUGUESE} "Nenhum"
LangString VisibilityHighContrast ${LANG_PORTUGUESE} "Alto Contraste"
LangString VisibilityMagnifier ${LANG_PORTUGUESE} "Magnifier"
LangString VisibilityScreenReader ${LANG_PORTUGUESE} "Leitor de Ecr"
LangString VisibilityBraille ${LANG_PORTUGUESE} "Terminal de Braile"
LangString MobilityKeyboardModifiers ${LANG_PORTUGUESE} "Modificadores de Teclado"
LangString MobilityOnScreenKeyboard ${LANG_PORTUGUESE} "Teclado no Ecr"

# CDBOOT
LangString CDBootTitle ${LANG_PORTUGUESE} "Install CD booter"
LangString CDBootText ${LANG_PORTUGUESE} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_PORTUGUESE} "Comear instalador em modo normal"
LangString BootMenuSafeGraphics ${LANG_PORTUGUESE} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_PORTUGUESE} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_PORTUGUESE} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_PORTUGUESE} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
